/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.io.IOException;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.debug.DebugEventSocketProxy;
import org.antlr.runtime.debug.DebugTokenStream;
import org.antlr.tool.ErrorManager;

public class DebugParser
extends Parser {
    protected DebugEventListener dbg = null;
    public boolean isCyclicDecision = false;

    public DebugParser(TokenStream tokenStream, DebugEventListener debugEventListener) {
        super(new DebugTokenStream(tokenStream, debugEventListener));
        this.setDebugListener(debugEventListener);
    }

    public DebugParser(TokenStream tokenStream) {
        this(tokenStream, 49153);
    }

    public DebugParser(TokenStream tokenStream, int n) {
        super(new DebugTokenStream(tokenStream, null));
        DebugEventSocketProxy debugEventSocketProxy = new DebugEventSocketProxy(this.getGrammarFileName(), n);
        this.setDebugListener(debugEventSocketProxy);
        try {
            debugEventSocketProxy.handshake();
        }
        catch (IOException iOException) {
            this.reportError(iOException);
        }
    }

    public void setDebugListener(DebugEventListener debugEventListener) {
        if (this.input instanceof DebugTokenStream) {
            ((DebugTokenStream)this.input).setDebugListener(debugEventListener);
        }
        this.dbg = debugEventListener;
    }

    public DebugEventListener getDebugListener() {
        return this.dbg;
    }

    public void reportError(IOException iOException) {
        ErrorManager.internalError(iOException);
    }

    public void beginResync() {
        this.dbg.beginResync();
    }

    public void endResync() {
        this.dbg.endResync();
    }

    public void beginBacktrack(int n) {
        this.dbg.beginBacktrack(n);
    }

    public void endBacktrack(int n, boolean bl) {
        this.dbg.endBacktrack(n, bl);
    }

    public void recoverFromMismatchedToken(IntStream intStream, RecognitionException recognitionException, int n, BitSet bitSet) throws RecognitionException {
        this.dbg.recognitionException(recognitionException);
        super.recoverFromMismatchedToken(intStream, recognitionException, n, bitSet);
    }

    public void recoverFromMismatchedSet(IntStream intStream, RecognitionException recognitionException, BitSet bitSet) throws RecognitionException {
        this.dbg.recognitionException(recognitionException);
        super.recoverFromMismatchedSet(intStream, recognitionException, bitSet);
    }
}

