/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.ReportTemplateSource;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.ResourceInfo;
import net.sf.jasperreports.repo.ResourcePathKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillReportTemplate
implements JRReportTemplate {
    private static final Log log = LogFactory.getLog(JRFillReportTemplate.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_TEMPLATE_SOURCE = "fill.report.template.unknown.template.source";
    private final JRReportTemplate parent;
    private final JRBaseFiller filler;

    public JRFillReportTemplate(JRReportTemplate template, JRBaseFiller filler, JRFillObjectFactory factory) {
        factory.put(template, this);
        this.parent = template;
        this.filler = filler;
    }

    @Override
    public JRExpression getSourceExpression() {
        return this.parent.getSourceExpression();
    }

    public ReportTemplateSource evaluate() throws JRException {
        JRExpression sourceExpression = this.getSourceExpression();
        Object source = this.filler.evaluateExpression(sourceExpression, (byte)3);
        ReportTemplateSource template = source == null ? null : (source instanceof JRTemplate ? ReportTemplateSource.of((JRTemplate)source) : JRFillReportTemplate.loadTemplate(source, this.filler, this.filler.getRepositoryContext()));
        return template;
    }

    protected static ReportTemplateSource loadTemplate(Object source, JRBaseFiller filler, RepositoryContext repositoryContext) throws JRException {
        ReportTemplateSource templateSource;
        Object cacheKey = source;
        if (source instanceof String) {
            cacheKey = ResourcePathKey.inContext(repositoryContext, (String)source);
        }
        if (filler.fillContext.hasLoadedTemplate(cacheKey)) {
            templateSource = filler.fillContext.getLoadedTemplate(cacheKey);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading styles template from " + source));
            }
            if (source instanceof String) {
                ResourceInfo resourceInfo = RepositoryUtil.getInstance(repositoryContext).getResourceInfo((String)source);
                if (resourceInfo == null) {
                    JRTemplate template = JRXmlTemplateLoader.getInstance(repositoryContext).loadTemplate((String)source);
                    templateSource = ReportTemplateSource.of(template);
                } else {
                    String resourceLocation = resourceInfo.getRepositoryResourceLocation();
                    ResourcePathKey absoluteKey = ResourcePathKey.absolute(resourceLocation);
                    if (filler.fillContext.hasLoadedTemplate(absoluteKey)) {
                        templateSource = filler.fillContext.getLoadedTemplate(absoluteKey);
                    } else {
                        JRTemplate template = JRXmlTemplateLoader.getInstance(repositoryContext).loadTemplate(resourceLocation);
                        templateSource = ReportTemplateSource.of(template, resourceInfo);
                        filler.fillContext.registerLoadedTemplate(absoluteKey, templateSource);
                    }
                }
            } else if (source instanceof File) {
                JRTemplate template = JRXmlTemplateLoader.getInstance(filler.getJasperReportsContext()).loadTemplate((File)source);
                templateSource = ReportTemplateSource.of(template);
            } else if (source instanceof URL) {
                JRTemplate template = JRXmlTemplateLoader.getInstance(filler.getJasperReportsContext()).loadTemplate((URL)source);
                templateSource = ReportTemplateSource.of(template);
            } else if (source instanceof InputStream) {
                JRTemplate template = JRXmlTemplateLoader.getInstance(filler.getJasperReportsContext()).loadTemplate((InputStream)source);
                templateSource = ReportTemplateSource.of(template);
            } else {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_TEMPLATE_SOURCE, new Object[]{source.getClass().getName()});
            }
            filler.fillContext.registerLoadedTemplate(cacheKey, templateSource);
        }
        return templateSource;
    }
}

