/*
 * Decompiled with CFR 0.152.
 */
package de.cenote.jasperstarter;

import de.cenote.jasperstarter.Config;
import de.cenote.jasperstarter.Db;
import de.cenote.jasperstarter.gui.ParameterPrompt;
import de.cenote.jasperstarter.types.DsType;
import de.cenote.jasperstarter.types.InputType;
import de.cenote.tools.printing.Printerlookup;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.data.JsonDataSource;
import net.sf.jasperreports.engine.data.JsonQLDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvMetadataExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsMetadataExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleCsvMetadataExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsMetadataReportConfiguration;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import net.sf.jasperreports.export.SimpleXmlExporterOutput;
import net.sf.jasperreports.view.JasperViewer;
import org.apache.commons.lang.LocaleUtils;

public class Report {
    private Config config;
    private File inputFile;
    private InputType initialInputType;
    private JasperDesign jasperDesign;
    private JasperReport jasperReport;
    private JasperPrint jasperPrint;
    private File output;
    private Locale defaultLocale;
    private static final String STDOUT = "-";
    private static PrintStream configSink = System.err;
    private static PrintStream debugSink = System.err;

    public Report(Config config, File inputFile) throws IllegalArgumentException {
        File parent;
        configSink = System.err;
        debugSink = System.err;
        this.config = config;
        this.defaultLocale = Locale.getDefault();
        this.inputFile = inputFile;
        Object inputObject = null;
        try {
            inputObject = JRLoader.loadObject((File)inputFile);
            Boolean casterror = true;
            try {
                this.jasperReport = (JasperReport)inputObject;
                casterror = false;
                this.initialInputType = InputType.JASPER_REPORT;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            try {
                this.jasperPrint = (JasperPrint)inputObject;
                casterror = false;
                this.initialInputType = InputType.JASPER_PRINT;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (casterror.booleanValue()) {
                throw new IllegalArgumentException("input file: \"" + inputFile + "\" is not of a valid type");
            }
        }
        catch (JRException ex) {
            try {
                this.jasperDesign = JRXmlLoader.load((String)inputFile.getAbsolutePath());
                this.initialInputType = InputType.JASPER_DESIGN;
                this.compile();
            }
            catch (JRException ex1) {
                throw new IllegalArgumentException("input file: \"" + inputFile + "\" is not a valid jrxml file: " + ex1.getMessage(), ex1);
            }
        }
        String inputBasename = inputFile.getName().split("\\.(?=[^\\.]+$)")[0];
        this.output = !config.hasOutput() ? ((parent = inputFile.getParentFile()) != null ? parent : new File(inputBasename)) : new File(config.getOutput());
        if (this.output.isDirectory()) {
            this.output = new File(this.output, inputBasename);
        }
        if (config.isVerbose()) {
            configSink.println("Input absolute :  " + inputFile.getAbsolutePath());
            try {
                configSink.println("Input canonical:  " + inputFile.getCanonicalPath());
            }
            catch (IOException ex) {
                Logger.getLogger(Report.class.getName()).log(Level.SEVERE, null, ex);
            }
            configSink.println("Input:            " + inputFile.getName());
            configSink.println("Input basename:   " + inputBasename);
            if (config.hasOutput()) {
                configSink.println("OutputParam:      " + config.getOutput());
            }
            if (this.output.getName().equals(STDOUT)) {
                configSink.println("Output:           " + this.output.getName());
            } else {
                configSink.println("Output:           " + this.output.getAbsolutePath());
                try {
                    configSink.println("Output canonical: " + this.output.getCanonicalPath());
                }
                catch (IOException ex) {
                    Logger.getLogger(Report.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void compile() throws JRException {
        this.jasperReport = JasperCompileManager.compileReport((JasperDesign)this.jasperDesign);
        if (this.config.isWriteJasper()) {
            String inputBasename = this.inputFile.getName().split("\\.(?=[^\\.]+$)")[0];
            String outputDir = this.inputFile.getParent();
            File outputFile = new File(outputDir + "/" + inputBasename + ".jasper");
            JRSaver.saveObject((Object)this.jasperReport, (File)outputFile);
        }
    }

    public void compileToFile() {
        if (this.initialInputType == InputType.JASPER_DESIGN) {
            try {
                JRSaver.saveObject((Object)this.jasperReport, (String)(this.output.getAbsolutePath() + ".jasper"));
            }
            catch (JRException ex) {
                throw new IllegalArgumentException("outputFile" + this.output.getAbsolutePath() + ".jaspercould not be written");
            }
        } else {
            throw new IllegalArgumentException("input file: \"" + this.inputFile + "\" is not a valid jrxml file");
        }
    }

    public void fill() throws InterruptedException {
        PrintStream originalStdout = System.out;
        try {
            System.setOut(System.err);
            this.fillInternal();
        }
        finally {
            System.out.flush();
            System.setOut(originalStdout);
        }
    }

    private void fillInternal() throws InterruptedException {
        if (this.initialInputType != InputType.JASPER_PRINT) {
            Map<String, Object> parameters = this.getCmdLineReportParams();
            if (this.config.hasAskFilter()) {
                JRParameter[] reportParams = this.jasperReport.getParameters();
                parameters = this.promptForParams(reportParams, parameters, this.jasperReport.getName());
            }
            try {
                Db db;
                if (parameters.containsKey("REPORT_LOCALE") && parameters.get("REPORT_LOCALE") != null) {
                    Locale.setDefault((Locale)parameters.get("REPORT_LOCALE"));
                }
                if (DsType.none.equals((Object)this.config.getDbType())) {
                    this.jasperPrint = JasperFillManager.fillReport((JasperReport)this.jasperReport, parameters, (JRDataSource)new JREmptyDataSource());
                } else if (DsType.csv.equals((Object)this.config.getDbType())) {
                    db = new Db();
                    JRCsvDataSource ds = db.getCsvDataSource(this.config);
                    this.jasperPrint = JasperFillManager.fillReport((JasperReport)this.jasperReport, parameters, (JRDataSource)ds);
                } else if (DsType.xml.equals((Object)this.config.getDbType())) {
                    if (this.config.xmlXpath == null) {
                        this.config.xmlXpath = this.getMainDatasetQuery();
                    }
                    db = new Db();
                    JRXmlDataSource ds = db.getXmlDataSource(this.config);
                    this.jasperPrint = JasperFillManager.fillReport((JasperReport)this.jasperReport, parameters, (JRDataSource)ds);
                } else if (DsType.json.equals((Object)this.config.getDbType())) {
                    if (this.config.jsonQuery == null) {
                        this.config.jsonQuery = this.getMainDatasetQuery();
                    }
                    db = new Db();
                    JsonDataSource ds = db.getJsonDataSource(this.config);
                    this.jasperPrint = JasperFillManager.fillReport((JasperReport)this.jasperReport, parameters, (JRDataSource)ds);
                } else if (DsType.jsonql.equals((Object)this.config.getDbType())) {
                    if (this.config.jsonQLQuery == null) {
                        this.config.jsonQLQuery = this.getMainDatasetQuery();
                    }
                    db = new Db();
                    JsonQLDataSource ds = db.getJsonQLDataSource(this.config);
                    this.jasperPrint = JasperFillManager.fillReport((JasperReport)this.jasperReport, parameters, (JRDataSource)ds);
                } else {
                    db = new Db();
                    Connection con = db.getConnection(this.config);
                    this.jasperPrint = JasperFillManager.fillReport((JasperReport)this.jasperReport, parameters, (Connection)con);
                    con.close();
                }
                Locale.setDefault(this.defaultLocale);
            }
            catch (SQLException ex) {
                throw new IllegalArgumentException("Unable to connect to database: " + ex.getMessage(), ex);
            }
            catch (JRException e) {
                throw new IllegalArgumentException("Error filling report" + e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to load driver: " + e.getMessage(), e);
            }
            finally {
                Locale.setDefault(this.defaultLocale);
            }
        }
    }

    public void print() throws JRException {
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (this.config.hasCopies()) {
            printRequestAttributeSet.add(new Copies(this.config.getCopies()));
        }
        HashPrintServiceAttributeSet printServiceAttributeSet = new HashPrintServiceAttributeSet();
        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
        if (this.config.hasReportName()) {
            this.jasperPrint.setName(this.config.getReportName());
        }
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        SimplePrintServiceExporterConfiguration expConfig = new SimplePrintServiceExporterConfiguration();
        if (this.config.hasPrinterName()) {
            String printerName = this.config.getPrinterName();
            PrintService service = Printerlookup.getPrintservice(printerName, Boolean.TRUE, Boolean.TRUE);
            expConfig.setPrintService(service);
            if (this.config.isVerbose()) {
                configSink.println("printer-name: " + (service == null ? "No printer found with name \"" + printerName + "\"! Using default." : "found: " + service.getName()));
            }
        }
        expConfig.setPrintRequestAttributeSet((PrintRequestAttributeSet)printRequestAttributeSet);
        expConfig.setPrintServiceAttributeSet((PrintServiceAttributeSet)printServiceAttributeSet);
        expConfig.setDisplayPageDialog(Boolean.FALSE);
        if (this.config.isWithPrintDialog()) {
            Report.setLookAndFeel();
            expConfig.setDisplayPrintDialog(Boolean.TRUE);
        } else {
            expConfig.setDisplayPrintDialog(Boolean.FALSE);
        }
        exporter.setConfiguration((ExporterConfiguration)expConfig);
        exporter.exportReport();
    }

    public void view() throws JRException {
        Report.setLookAndFeel();
        JasperViewer.viewReport((JasperPrint)this.jasperPrint, (boolean)false);
    }

    private OutputStream getOutputStream(String suffix) throws JRException {
        OutputStream outputStream;
        if (this.output.getName().equals(STDOUT)) {
            outputStream = System.out;
        } else {
            String outputPath = this.output.getAbsolutePath() + suffix;
            try {
                outputStream = new FileOutputStream(outputPath);
            }
            catch (IOException ex) {
                throw new JRException("Unable to create outputStream to " + outputPath, (Throwable)ex);
            }
        }
        return outputStream;
    }

    public void exportJrprint() throws JRException {
        JRSaver.saveObject((Object)this.jasperPrint, (OutputStream)this.getOutputStream(".jrprint"));
    }

    public void exportPdf() throws JRException {
        JasperExportManager.exportReportToPdfStream((JasperPrint)this.jasperPrint, (OutputStream)this.getOutputStream(".pdf"));
    }

    public void exportRtf() throws JRException {
        JRRtfExporter exporter = new JRRtfExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(this.getOutputStream(".rtf")));
        exporter.exportReport();
    }

    public void exportDocx() throws JRException {
        JRDocxExporter exporter = new JRDocxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(this.getOutputStream(".docx")));
        exporter.exportReport();
    }

    public void exportOdt() throws JRException {
        JROdtExporter exporter = new JROdtExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(this.getOutputStream(".odt")));
        exporter.exportReport();
    }

    public void exportHtml() throws JRException {
        HtmlExporter exporter = new HtmlExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput(this.getOutputStream(".html")));
        exporter.exportReport();
    }

    public void exportXml() throws JRException {
        JRXmlExporter exporter = new JRXmlExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        SimpleXmlExporterOutput outputStream = new SimpleXmlExporterOutput(this.getOutputStream(".xml"));
        outputStream.setEmbeddingImages(Boolean.valueOf(false));
        exporter.setExporterOutput((ExporterOutput)outputStream);
        exporter.exportReport();
    }

    public void exportXls() throws JRException {
        HashMap<String, String> dateFormats = new HashMap<String, String>();
        dateFormats.put("EEE, MMM d, yyyy", "ddd, mmm d, yyyy");
        JRXlsExporter exporter = new JRXlsExporter();
        SimpleXlsReportConfiguration repConfig = new SimpleXlsReportConfiguration();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(this.getOutputStream(".xls")));
        repConfig.setDetectCellType(Boolean.TRUE);
        repConfig.setFormatPatternsMap(dateFormats);
        exporter.setConfiguration((ReportExportConfiguration)repConfig);
        exporter.exportReport();
    }

    public void exportXlsMeta() throws JRException {
        HashMap<String, String> dateFormats = new HashMap<String, String>();
        dateFormats.put("EEE, MMM d, yyyy", "ddd, mmm d, yyyy");
        JRXlsMetadataExporter exporter = new JRXlsMetadataExporter();
        SimpleXlsMetadataReportConfiguration repConfig = new SimpleXlsMetadataReportConfiguration();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(this.getOutputStream(".xls")));
        repConfig.setDetectCellType(Boolean.TRUE);
        repConfig.setFormatPatternsMap(dateFormats);
        exporter.setConfiguration((ReportExportConfiguration)repConfig);
        exporter.exportReport();
    }

    public void exportXlsx() throws JRException {
        HashMap<String, String> dateFormats = new HashMap<String, String>();
        dateFormats.put("EEE, MMM d, yyyy", "ddd, mmm d, yyyy");
        JRXlsxExporter exporter = new JRXlsxExporter();
        SimpleXlsxReportConfiguration repConfig = new SimpleXlsxReportConfiguration();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(this.getOutputStream(".xlsx")));
        repConfig.setDetectCellType(Boolean.TRUE);
        repConfig.setFormatPatternsMap(dateFormats);
        exporter.setConfiguration((ReportExportConfiguration)repConfig);
        exporter.exportReport();
    }

    public void exportCsv() throws JRException {
        JRCsvExporter exporter = new JRCsvExporter();
        SimpleCsvExporterConfiguration configuration = new SimpleCsvExporterConfiguration();
        configuration.setFieldDelimiter(this.config.getOutFieldDel());
        exporter.setConfiguration((ExporterConfiguration)configuration);
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(this.getOutputStream(".csv"), this.config.getOutCharset()));
        exporter.exportReport();
    }

    public void exportCsvMeta() throws JRException {
        JRCsvMetadataExporter exporter = new JRCsvMetadataExporter();
        SimpleCsvMetadataExporterConfiguration configuration = new SimpleCsvMetadataExporterConfiguration();
        configuration.setFieldDelimiter(this.config.getOutFieldDel());
        exporter.setConfiguration((ExporterConfiguration)configuration);
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(this.getOutputStream(".csv"), this.config.getOutCharset()));
        exporter.exportReport();
    }

    public void exportOds() throws JRException {
        JROdsExporter exporter = new JROdsExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(this.getOutputStream(".ods")));
        exporter.exportReport();
    }

    public void exportPptx() throws JRException {
        JRPptxExporter exporter = new JRPptxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(this.getOutputStream(".pptx")));
        exporter.exportReport();
    }

    public void exportXhtml() throws JRException {
        HtmlExporter exporter = new HtmlExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput(this.getOutputStream(".x.html")));
        exporter.exportReport();
    }

    private Map<String, Object> getCmdLineReportParams() {
        JRParameter[] jrParameterArray = this.jasperReport.getParameters();
        HashMap<String, JRParameter> jrParameters = new HashMap<String, JRParameter>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.config.hasParams()) {
            List<String> params = this.config.getParams();
            for (JRParameter rp : jrParameterArray) {
                jrParameters.put(rp.getName(), rp);
            }
            String paramName = null;
            String paramValue = null;
            for (String p : params) {
                try {
                    paramName = p.split("=")[0];
                    paramValue = p.split("=", 2)[1];
                    if (this.config.isVerbose()) {
                        configSink.println("Using report parameter: " + paramName + " = " + paramValue);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Wrong report param format! " + p, e);
                }
                if (!jrParameters.containsKey(paramName)) {
                    throw new IllegalArgumentException("Parameter '" + paramName + "' does not exist in report!");
                }
                JRParameter reportParam = (JRParameter)jrParameters.get(paramName);
                try {
                    if (Date.class.equals((Object)reportParam.getValueClass())) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd");
                        parameters.put(paramName, dateFormat.parse(paramValue));
                        continue;
                    }
                    if (Image.class.equals((Object)reportParam.getValueClass())) {
                        Image image = Toolkit.getDefaultToolkit().createImage(JRLoader.loadBytes((File)new File(paramValue)));
                        MediaTracker traker = new MediaTracker(new Panel());
                        traker.addImage(image, 0);
                        try {
                            traker.waitForID(0);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Image tracker error: " + e.getMessage(), e);
                        }
                        parameters.put(paramName, image);
                        continue;
                    }
                    if (Locale.class.equals((Object)reportParam.getValueClass())) {
                        parameters.put(paramName, LocaleUtils.toLocale((String)paramValue));
                        continue;
                    }
                    try {
                        parameters.put(paramName, reportParam.getValueClass().getConstructor(String.class).newInstance(paramValue));
                    }
                    catch (InstantiationException ex) {
                        throw new IllegalArgumentException("Parameter '" + paramName + "' of type '" + reportParam.getValueClass().getName() + " caused " + ex.getClass().getName() + " " + ex.getMessage(), ex);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalArgumentException("Parameter '" + paramName + "' of type '" + reportParam.getValueClass().getName() + " caused " + ex.getClass().getName() + " " + ex.getMessage(), ex);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable cause = ex.getCause();
                        throw new IllegalArgumentException("Parameter '" + paramName + "' of type '" + reportParam.getValueClass().getName() + " caused " + cause.getClass().getName() + " " + cause.getMessage(), cause);
                    }
                    catch (NoSuchMethodException ex) {
                        throw new IllegalArgumentException("Parameter '" + paramName + "' of type '" + reportParam.getValueClass().getName() + " with value '" + paramValue + "' is not supported by JasperStarter!", ex);
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("NumberFormatException: " + e.getMessage() + "\" in \"" + p + "\"", e);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e.getMessage() + "\" in \"" + p + "\"", e);
                }
                catch (JRException e) {
                    throw new IllegalArgumentException("Unable to load image from: " + paramValue, e);
                }
            }
        }
        return parameters;
    }

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException e) {
            Logger.getLogger(Report.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger(Report.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (InstantiationException e) {
            Logger.getLogger(Report.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(Report.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private Map<String, Object> promptForParams(JRParameter[] reportParams, Map<String, Object> params, String reportName) throws InterruptedException {
        boolean isForPromptingOnly = false;
        boolean isUserDefinedOnly = false;
        boolean emptyOnly = false;
        switch (this.config.getAskFilter()) {
            case ae: {
                emptyOnly = true;
            }
            case a: {
                isForPromptingOnly = false;
                isUserDefinedOnly = false;
                break;
            }
            case ue: {
                emptyOnly = true;
            }
            case u: {
                isUserDefinedOnly = true;
                break;
            }
            case pe: {
                emptyOnly = true;
            }
            case p: {
                isUserDefinedOnly = true;
                isForPromptingOnly = true;
            }
        }
        Report.setLookAndFeel();
        ParameterPrompt prompt = new ParameterPrompt(null, reportParams, params, reportName, isForPromptingOnly, isUserDefinedOnly, emptyOnly);
        if (0 != prompt.show()) {
            throw new InterruptedException("User aborted at parameter promt!");
        }
        if (this.config.isVerbose()) {
            configSink.println("----------------------------");
            configSink.println("Parameter prompt:");
            for (String key : params.keySet()) {
                configSink.println(key + " = " + params.get(key));
            }
            configSink.println("----------------------------");
        }
        return params;
    }

    public JRParameter[] getReportParameters() throws IllegalArgumentException {
        JRParameter[] returnval = null;
        if (this.jasperReport == null) {
            throw new IllegalArgumentException("Parameters could not be read from " + this.inputFile.getAbsolutePath());
        }
        returnval = this.jasperReport.getParameters();
        return returnval;
    }

    public String getMainDatasetQuery() throws IllegalArgumentException {
        if (this.initialInputType == InputType.JASPER_DESIGN) {
            return this.jasperDesign.getMainDesignDataset().getQuery().getText();
        }
        if (this.initialInputType == InputType.JASPER_REPORT) {
            return this.jasperReport.getMainDataset().getQuery().getText();
        }
        throw new IllegalArgumentException("No query for input type: " + (Object)((Object)this.initialInputType));
    }
}

