/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JCalendar;
import com.toedter.calendar.JTextFieldDateEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JDateChooser
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -4306412745720670722L;
    protected IDateEditor dateEditor;
    protected JButton calendarButton;
    protected JCalendar jcalendar;
    protected JPopupMenu popup;
    protected boolean isInitialized;
    protected boolean dateSelected;
    protected Date lastSelectedDate;
    private ChangeListener changeListener;

    public JDateChooser() {
        this(null, null, null, null);
    }

    public JDateChooser(IDateEditor iDateEditor) {
        this(null, null, null, iDateEditor);
    }

    public JDateChooser(Date date) {
        this(date, null);
    }

    public JDateChooser(Date date, String string) {
        this(date, string, null);
    }

    public JDateChooser(Date date, String string, IDateEditor iDateEditor) {
        this(null, date, string, iDateEditor);
    }

    public JDateChooser(String string, String string2, char c) {
        this(null, null, string, new JTextFieldDateEditor(string, string2, c));
    }

    public JDateChooser(JCalendar jCalendar, Date date, String string, IDateEditor iDateEditor) {
        this.setName("JDateChooser");
        this.dateEditor = iDateEditor;
        if (this.dateEditor == null) {
            this.dateEditor = new JTextFieldDateEditor();
        }
        this.dateEditor.addPropertyChangeListener("date", this);
        if (jCalendar == null) {
            this.jcalendar = new JCalendar(date);
        } else {
            this.jcalendar = jCalendar;
            if (date != null) {
                this.jcalendar.setDate(date);
            }
        }
        this.setLayout(new BorderLayout());
        this.jcalendar.getDayChooser().addPropertyChangeListener("day", this);
        this.jcalendar.getDayChooser().setAlwaysFireDayProperty(true);
        this.setDateFormatString(string);
        this.setDate(date);
        URL uRL = this.getClass().getResource("/com/toedter/calendar/images/JDateChooserIcon.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.calendarButton = new JButton((Icon)imageIcon){
            private static final long serialVersionUID = -1913767779079949668L;

            public boolean isFocusable() {
                return false;
            }
        };
        this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
        this.calendarButton.addActionListener(this);
        this.calendarButton.setMnemonic(67);
        this.add((Component)this.calendarButton, "East");
        this.add((Component)this.dateEditor.getUiComponent(), "Center");
        this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
        this.popup = new JPopupMenu(){
            private static final long serialVersionUID = -6078272560337577761L;

            public void setVisible(boolean bl) {
                Boolean bl2 = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (bl || !bl && JDateChooser.this.dateSelected || bl2 != null && !bl && bl2.booleanValue()) {
                    super.setVisible(bl);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add(this.jcalendar);
        this.lastSelectedDate = date;
        this.changeListener = new ChangeListener(){
            boolean hasListened = false;

            public void stateChanged(ChangeEvent changeEvent) {
                if (this.hasListened) {
                    this.hasListened = false;
                    return;
                }
                if (JDateChooser.this.popup.isVisible() && JDateChooser.this.jcalendar.monthChooser.getComboBox().hasFocus()) {
                    MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    menuElementArray2[0] = JDateChooser.this.popup;
                    for (int i = 0; i < menuElementArray.length; ++i) {
                        menuElementArray2[i + 1] = menuElementArray[i];
                    }
                    this.hasListened = true;
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                }
            }
        };
        MenuSelectionManager.defaultManager().addChangeListener(this.changeListener);
        this.isInitialized = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.calendarButton.getWidth() - (int)this.popup.getPreferredSize().getWidth();
        int n2 = this.calendarButton.getY() + this.calendarButton.getHeight();
        Calendar calendar = Calendar.getInstance();
        Date date = this.dateEditor.getDate();
        if (date != null) {
            calendar.setTime(date);
        }
        this.jcalendar.setCalendar(calendar);
        this.popup.show(this.calendarButton, n, n2);
        this.dateSelected = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("day")) {
            if (this.popup.isVisible()) {
                this.dateSelected = true;
                this.popup.setVisible(false);
                if ((Integer)propertyChangeEvent.getNewValue() > 0) {
                    this.setDate(this.jcalendar.getCalendar().getTime());
                } else {
                    this.setDate(null);
                }
            }
        } else if (propertyChangeEvent.getPropertyName().equals("date")) {
            if (propertyChangeEvent.getSource() == this.dateEditor) {
                this.firePropertyChange("date", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else {
                this.setDate((Date)propertyChangeEvent.getNewValue());
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setEnabled(this.isEnabled());
        if (this.jcalendar != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.dateEditor.setLocale(locale);
        this.jcalendar.setLocale(locale);
    }

    public String getDateFormatString() {
        return this.dateEditor.getDateFormatString();
    }

    public void setDateFormatString(String string) {
        this.dateEditor.setDateFormatString(string);
        this.invalidate();
    }

    public Date getDate() {
        return this.dateEditor.getDate();
    }

    public void setDate(Date date) {
        this.dateEditor.setDate(date);
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public Calendar getCalendar() {
        Date date = this.getDate();
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public void setCalendar(Calendar calendar) {
        if (calendar == null) {
            this.dateEditor.setDate(null);
        } else {
            this.dateEditor.setDate(calendar.getTime());
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.dateEditor != null) {
            this.dateEditor.setEnabled(bl);
            this.calendarButton.setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void setIcon(ImageIcon imageIcon) {
        this.calendarButton.setIcon(imageIcon);
    }

    public void setFont(Font font) {
        if (this.isInitialized) {
            this.dateEditor.getUiComponent().setFont(font);
            this.jcalendar.setFont(font);
        }
        super.setFont(font);
    }

    public JCalendar getJCalendar() {
        return this.jcalendar;
    }

    public JButton getCalendarButton() {
        return this.calendarButton;
    }

    public IDateEditor getDateEditor() {
        return this.dateEditor;
    }

    public void setSelectableDateRange(Date date, Date date2) {
        this.jcalendar.setSelectableDateRange(date, date2);
        this.dateEditor.setSelectableDateRange(this.jcalendar.getMinSelectableDate(), this.jcalendar.getMaxSelectableDate());
    }

    public void setMaxSelectableDate(Date date) {
        this.jcalendar.setMaxSelectableDate(date);
        this.dateEditor.setMaxSelectableDate(date);
    }

    public void setMinSelectableDate(Date date) {
        this.jcalendar.setMinSelectableDate(date);
        this.dateEditor.setMinSelectableDate(date);
    }

    public Date getMaxSelectableDate() {
        return this.jcalendar.getMaxSelectableDate();
    }

    public Date getMinSelectableDate() {
        return this.jcalendar.getMinSelectableDate();
    }

    public void cleanup() {
        MenuSelectionManager.defaultManager().removeChangeListener(this.changeListener);
        this.changeListener = null;
    }

    public boolean requestFocusInWindow() {
        if (this.dateEditor instanceof JComponent) {
            return ((JComponent)((Object)this.dateEditor)).requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JDateChooser");
        JDateChooser jDateChooser = new JDateChooser();
        jFrame.getContentPane().add(jDateChooser);
        jFrame.pack();
        jFrame.setVisible(true);
        jDateChooser.requestFocusInWindow();
    }
}

